<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuItem extends Model 
{

    protected $table = 'menu_items';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function menus()
    {
        return $this->belongsToMany('App\Models\Menu', 'menus_menu_items');
    }

    public function menuItemUserLikes()
    {
        return $this->belongsToMany('App\Models\User', 'menu_items_users_like', 'menu_item_id', 'user_id');
    }

}